/*
 *
 *  A canvas to PDF converter. Uses a mock canvas context to build a PDF document.
 *
 *  Licensed under the MIT license:
 *  http://www.opensource.org/licenses/mit-license.php
 *
 *  Author:
 *  Joshua Gould
 *
 *  @license Copyright (c) 2017 Joshua Gould
 */
!function(t){"use strict";var e=void 0!==e?e:{};function i(t,e,i,n){t=t%360+360*(t<0);var r=i+(i<.5?i:1-i)*(e=isNaN(t)||isNaN(e)?0:e),s=2*i-r;return l(o(t>=240?t-240:t+120,s,r),o(t,s,r),o(t<120?t+240:t-120,s,r),n)}function o(t,e,i){return 255*(t<60?e+(i-e)*t/60:t<180?i:t<240?e+(i-e)*(240-t)/60:e)}t.canvas2pdf=e;var n="\\s*([+-]?\\d+)\\s*",r="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",s="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",a=new RegExp("^rgb\\("+[n,n,n]+"\\)$"),h=new RegExp("^rgb\\("+[s,s,s]+"\\)$"),c=new RegExp("^rgba\\("+[n,n,n,r]+"\\)$"),p=new RegExp("^rgba\\("+[s,s,s,r]+"\\)$"),d=new RegExp("^hsl\\("+[r,s,s]+"\\)$"),f=new RegExp("^hsla\\("+[r,s,s,r]+"\\)$"),l=function(t,e,i,o){return{c:t/255+" "+e/255+" "+i/255,a:o}},u=function(t){if(!t)return{c:"0 0 0",a:1};if(!t.toString().startsWith("rgb")&&!t.toString().startsWith("hsl")){var e=document.createElement("div");e.style.color=t,document.body.appendChild(e),t=window.getComputedStyle(e).color+"",document.body.removeChild(e)}var o,n=((t=t.replace(/\s/g,""))+"").trim().toLowerCase();return(o=a.exec(n))?l(o[1],o[2],o[3],1):(o=h.exec(n))?l(255*o[1]/100,255*o[2]/100,255*o[3]/100,1):(o=c.exec(n))?l(o[1],o[2],o[3],o[4]):(o=p.exec(n))?l(255*o[1]/100,255*o[2]/100,255*o[3]/100,o[4]):(o=d.exec(n))?i(o[1],o[2]/100,o[3]/100):(o=f.exec(n))?i(o[1],o[2]/100,o[3]/100,o[4]):{c:t,a:1}};
/*
	@license MIT LICENSE
	Copyright (c) 2014 Devon Govett

	Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	*/function g(){this.objects=[],this.catalog=this.add(new m),this.pages=this.add(new y),this.catalog.setPages(this.pages),this.pageWidth=8.27,this.pageHeight=11.69,this.textStyle=new F,this.fonts=[],this.lineWidth=1,this.lineEndType=0,this.alpha=1,e.useFlateDecode=!!window.pako||!!window.fflate,e.deflate=function(t){var e=t;if(window.pako)return window.pako.deflate(e);if(window.fflate){if("string"==typeof e)e=(new TextEncoder).encode(e);return window.fflate.zlibSync(e)}return e}}function m(){}function y(){this.pages=[]}function x(t,e,i,o){this.pdf=t,this.fonts=[],this.images=[],this.fillImages=[],this.alphas=[],this.fillColor="0 0 0 ",this.strokeColor="0 0 0 ",this.lineWidth=2,this.lineCap=0,this.lineJoin=1,this.fontSize=12,this.font="normal",this.width=72*e,this.height=72*i,this.pagesID=o,this._ctm=[1,0,0,1,0,0]}function P(t){this.fontName=t}function v(){this.stream=""}e.PdfContext=function(t,e,i){var o=this,n=new g;this.doc=n;var r=document.createElement("canvas");this.context=r.getContext("2d"),n.pageSetWidth(t/72),n.pageSetHeight(e/72),n.addPage(i);var s="10px Helvetica";this.textAlign="left",this.textBaseline="alphabetic";Object.defineProperty(this,"fillStyle",{get:function(){return this.fillColor},set:function(t){if(this.fillColor=t,t instanceof b)console.log("TODO",o.doc);else if(t.toString().startsWith("rgb")||t.toString().startsWith("hsl")){var e=u(t);o.doc.fillColor(e.c,e.a)}}}),Object.defineProperty(this,"strokeStyle",{get:function(){return o.doc.strokeColor()},set:function(t){var e=u(t);o.doc.strokeColor(e.c,e.a)}}),Object.defineProperty(this,"lineWidth",{get:function(){return o.doc.setLineWidth()},set:function(t){o.doc.setLineWidth(t)}}),Object.defineProperty(this,"lineCap",{get:function(){return"butt"},set:function(t){o.doc.lineCap(t)}}),Object.defineProperty(this,"lineJoin",{get:function(){return"miter"},set:function(t){o.doc.lineJoin(t)}}),Object.defineProperty(this,"miterLimit",{get:function(){return 10},set:function(){}}),Object.defineProperty(this,"globalAlpha",{get:function(){return o.doc.opacity()},set:function(t){o.doc.opacity(t)}}),Object.defineProperty(this,"font",{get:function(){return s},set:function(t){this.context.font=t,s=t;var e,i,n=((i=(e=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-_,\'\"\sa-z0-9]+?)\s*$/i).exec(o.font))||(console.log("error parsing font "+o.font),i=e.exec("10px Helvetica")),i[6].indexOf("sans-serif")>-1&&(i[6]="Helvetica"),i[6].indexOf("serif")>-1&&(i[6]="Times-Roman"),{style:i[1]||"normal",size:parseInt(i[4])||10,family:i[6]||"Helvetica",weight:i[3]||"normal"});o.doc.fontSize(n.size),o.doc.font(n.family),o.doc.setFontStyle("normal"!=n.weight,"normal"!=n.style,!1)}}),this.font=s,this.strokeStyle="rgb(0,0,0)",this.fillStyle="rgb(0,0,0)"},e.PdfContext.prototype.end=function(){this.doc.end()},e.PdfContext.prototype.addPage=function(t){this.doc.addPage(t)},e.PdfContext.prototype.save=function(){this.doc.save()},e.PdfContext.prototype.restore=function(){this.doc.restore()},e.PdfContext.prototype.transform=function(t,e,i,o,n,r){this.doc.transform(t,e,i,o,n,r)},e.PdfContext.prototype.scale=function(t,e){this.doc.scale(t,e)},e.PdfContext.prototype.rotate=function(t){var e=180*t/Math.PI;this.doc.rotate(e)},e.PdfContext.prototype.translate=function(t,e){this.doc.translate(t,e)},e.PdfContext.prototype.beginPath=function(){this.doc.beginPath()},e.PdfContext.prototype.moveTo=function(t,e){this.doc.moveTo(t,e)},e.PdfContext.prototype.closePath=function(){this.doc.closePath()},e.PdfContext.prototype.lineTo=function(t,e){this.doc.lineTo(t,e)},e.PdfContext.prototype.stroke=function(){this.doc.stroke()},e.PdfContext.prototype.fill=function(t){this.doc.fill(t)},e.PdfContext.prototype.rect=function(t,e,i,o){this.doc.rect(t,e,i,o)},e.PdfContext.prototype.fillRect=function(t,e,i,o){this.doc.beginPath(),this.doc.rect(t,e,i,o),this.doc.fill()},e.PdfContext.prototype.strokeRect=function(t,e,i,o){this.doc.beginPath(),this.doc.rect(t,e,i,o),this.doc.stroke()},e.PdfContext.prototype.clearRect=function(t,e,i,o){var n=this.doc.fillColor();this.doc.fillColor("white"),this.doc.rect(t,e,i,o),this.doc.fill(),this.doc.fillColor(n)},e.PdfContext.prototype.arc=function(t,e,i,o,n,r){this.doc.arc(t,e,i,o,n,r)},e.PdfContext.prototype.bezierCurveTo=function(t,e,i,o,n,r){this.doc.bezierCurveTo(t,e,i,o,n,r)},e.PdfContext.prototype.quadraticCurveTo=function(t,e,i,o){this.doc.quadraticCurveTo(t,e,i,o)},e.PdfContext.prototype.createLinearGradient=function(t,e,i,o){return this.doc.linearGradient(t,e,i,o)},e.PdfContext.prototype.createRadialGradient=function(t,e,i,o,n,r){var s=this.doc.radialGradient(t,e,i,o,n,r);return s.addColorStop=function(t,e){var i=u(e);s.stop(t,i.c,i.a)},s},e.PdfContext.prototype.fillText=function(t,e,i){t&&t.trim().length&&this.doc.textAdd(e,i,t)},e.PdfContext.prototype.strokeText=function(){console.log("strokeText not implemented, use fillText")},e.PdfContext.prototype.measureText=function(t){return this.context.measureText(t+"")},e.PdfContext.prototype.clip=function(){this.doc.clip()},e.PdfContext.prototype.getPDFbase64=function(){return this.doc.getBase64Text()},e.PdfContext.prototype.getPDFtext=function(){return this.doc.getText()},e.PdfContext.prototype.drawImage=function(t,e,i,o,n){var r=this.doc.currentPage._ctm,s=r[0]*r[3]-r[1]*r[2];return this.doc.drawImage(t,e,i,o,n,Math.sqrt(Math.abs(s)))},e.PdfContext.prototype.setLineDash=function(t){return this.doc.setLineDash(t)},e.PdfContext.prototype.createPattern=function(t){var e=this.doc.imageTileLoad(t);return{setTransform:t=>{e.matrix=t}}},e.PdfContext.prototype.setTransform=function(){console.log("setTransform not implemented")},e.PdfContext.prototype.drawFocusRing=function(){console.log("drawFocusRing not implemented")},e.PdfContext.prototype.createImageData=function(){console.log("drawFocusRing not implemented")},e.PdfContext.prototype.getImageData=function(){console.log("getImageData not implemented")},e.PdfContext.prototype.putImageData=function(){console.log("putImageData not implemented")},e.PdfContext.prototype.globalCompositeOperation=function(){console.log("globalCompositeOperation not implemented")},e.PdfContext.prototype.arcTo=function(){console.log("arcTo not implemented")},g.prototype.add=function(t){return this.objects.push(t),t.id=this.objects.length,t},g.prototype.pageSetWidth=function(t){this.pageWidth=t},g.prototype.pageSetHeight=function(t){this.pageHeight=t},g.prototype.addPage=function(t){this.currentPage=new x(this,this.pageWidth,this.pageHeight,this.pages.id),this.currentPage.dpi=t?.dpi||72,this.add(this.currentPage),this.pages.addPage(this.currentPage);var e=new v;this.add(e),this.currentPage.setStream(e),t&&t.verticalFlip||this.currentPage.transform(1,0,0,-1,0,this.currentPage.height)},g.prototype.font=function(t){this.currentPage.setFontName(t)},g.prototype.fontSize=function(t){this.currentPage.setFontSize(t)},g.prototype.lineJoin=function(t){this.currentPage.setLineJoin(t)},g.prototype.lineCap=function(t){this.currentPage.setLineCap(t)},g.prototype.setLineWidth=function(t){this.currentPage.setLineWidth(t)},g.prototype.strokeColor=function(t,e){this.currentPage.setStrokeColor(t,e)},g.prototype.fillColor=function(t,e){this.currentPage.setFillColor(t,e)},g.prototype.pageSetCurrent=function(t){this.currentPage=t},g.prototype.font=function(t){this.textStyle.setFontName(t)},g.prototype.fontSetSize=function(t){this.textStyle.fontSetSize(t)},g.prototype.setFontStyle=function(t,e){this.textStyle.setFontStyle(t,e)},g.prototype.setFont=function(t){var e=t.getFontName();if(null!=e){var i,o=null;for(i=0;i<this.fonts.length;i++)this.fonts[i].fontName==e&&(o=this.fonts[i]);null==o&&(o=new P(e),this.add(o),this.fonts.push(o)),t.setFont(o)}},g.prototype.textAdd=function(t,e,i){var o=this.textStyle.clone();this.setFont(o),this.currentPage.textAdd(t,e,i,o)},g.prototype.imageLoadFromCanvas=function(t,e){(t=new w(t)).scale=e,this.add(t),t.mask&&this.add(t.mask),this.currentImage=t},g.prototype.imageTileLoadFromCanvas=function(t){return(t=new j(t,this.currentPage.fillColor,1*this.currentPage.alpha)).vectorPattern&&this.add(t.vectorPattern),this.add(t),this.currentPage.currentImageTile=t,t},g.prototype.linearGradient=function(t,e,i,o){var n=new b(t,e,i,o,this.currentPage);return this.add(n),this.currentPage.currentImageTile=n,this.addPatternToPage(n),n},g.prototype.doDrawImage=function(t,e,i,o){this.currentPage.drawImage(t,e,this.currentImage,this.alpha,i,o)},g.prototype.addPatternToPage=function(t){this.currentPage.addPatternToPage(t)},g.prototype.moveTo=function(t,e){this.currentPage.moveTo(t,e)},g.prototype.lineTo=function(t,e){this.currentPage.lineTo(t,e)},g.prototype.bezierCurveTo=function(t,e,i,o,n,r){this.currentPage.bezierCurveTo(t,e,i,o,n,r)},g.prototype.translate=function(t,e){this.currentPage.translate(t,e)},g.prototype.transform=function(t,e,i,o,n,r){this.currentPage.transform(t,e,i,o,n,r)},g.prototype.drawImage=function(t,e,i,o,n,r){var s=1;if("img"==t.nodeName.toLowerCase()){var a=document.createElement("canvas");t.src.startsWith&&t.src.startsWith("data:image/svg")&&(s=2*Math.max(1,r||1)*this.currentPage.dpi/72),a.width=t.width*s,a.height=t.height*s,a.getContext("2d").drawImage(t,0,0,t.width,t.height,0,0,a.width,a.height),t=a}this.imageLoadFromCanvas(t,s),this.doDrawImage(e,i,t.width,t.height)},g.prototype.imageTileLoad=function(t){if(t.nodeName&&"img"==t.nodeName.toLowerCase()){var e=document.createElement("canvas");e.width=t.width,e.height=t.height,e.getContext("2d").drawImage(t,0,0),t=e}var i=this.imageTileLoadFromCanvas(t);return this.addPatternToPage(this.currentPage.currentImageTile),i},g.prototype.scale=function(t,e,i){this.currentPage.scale(t,e,i)},g.prototype.rotate=function(t,e){this.currentPage.rotate(t,e)},g.prototype.beginPath=function(){this.currentPage.beginPath()},g.prototype.arc=function(t,e,i,o,n,r){this.currentPage.arc(t,e,i,o,n,r)},g.prototype.closePath=function(){this.currentPage.closePath()},g.prototype.stroke=function(){this.currentPage.stroke()},g.prototype.clip=function(t){this.currentPage.clip(t)},g.prototype.opacity=function(t){this.currentPage.setAlpha(t)},g.prototype.setLineDash=function(t){this.currentPage.setLineDash(t)},g.prototype.save=function(){this.currentPage.saveContext()},g.prototype.restore=function(){this.currentPage.restoreContext()},g.prototype.fill=function(t){this.currentPage.fill(t)},g.prototype.rect=function(t,e,i,o){this.currentPage.rect(t,e,i,o)},g.prototype.quadraticCurveTo=function(t,e,i,o){this.currentPage.quadraticCurveTo(t,e,i,o)},g.prototype.graphicsSetAlpha=function(t){this.alpha=Math.floor(100*t/255)/100,this.textStyle.setAlpha(t)},g.prototype.graphicsSetLineEndType=function(t){this.lineEndType=t},g.prototype._write=function(t){this.stream+=t+"\n"},g.prototype.getObject=function(t){var e,i;for(this.stream="",this._write("%PDF-1.7"),e=0;e<this.objects.length;e++)(i=this.objects[e]).offset=this.stream.length,i=i.getObject(this,t),this._write(i);t=this.stream.length,this._write("xref"),this._write("0 "+(this.objects.length+1)),this._write("0000000000 65535 f");var o=this.objects;for(e=0;e<o.length;e++){var n=this.objects[e].offset;n=("0000000000"+n).slice(-10),this._write(n+" 00000 n")}return this._write("trailer"),this._write(C.convert({Size:this.objects.length+1,Root:new T(this.catalog.id+" 0 R")})),this._write("startxref"),this._write(t),this._write("%%EOF"),this.stream},g.prototype.getBase64Text=function(){return"data:application/pdf;base64,"+btoa(this.getObject(this))},m.prototype.setPages=function(t){this.props={Type:"Catalog",Pages:new T(t.id+" 0 R")}},m.prototype.getObject=function(){return C.makeObject(this.props,this.id)},y.prototype.addPage=function(t){return this.pages.push(t),t.setPageNumber(this.pages.length),t},y.prototype.getObject=function(){for(var t="[",e=0;e<this.pages.length;e++)t+=this.pages[e].id,t+=" 0 R ";t+="]";var i={Type:"Pages",Count:this.pages.length,Kids:new T(t)};return C.makeObject(i,this.id)},x.prototype.setStream=function(t){this.pdfStream=t},x.prototype.setPageNumber=function(t){this.pageNumber=t},x.prototype.textAdd=function(t,e,i,o){var n=this.fontSize;-1==this.fonts.indexOf(o.font)&&this.fonts.push(o.font),i=C.convert(new String(i)),this.setAlpha(o.alpha),e=this.height-e,this.saveContext(),this.transform(1,0,0,-1,0,this.height),this.pdfStream.addText("BT "+this.strokeColor+" rg /F"+o.font.id+" "+n+" Tf 1 0 0 1 "+t+" "+e+" cm "+i+"Tj ET "),this.restoreContext()},x.prototype.setAlpha=function(t){var e=1*t;if(this.currentAlpha!=e){-1==this.alphas.indexOf(e)&&this.alphas.push(e);var i=this.alphas.indexOf(e);this.pdfStream.addText("/Alpha"+i+" gs "),this.currentAlpha=e}},x.prototype.moveTo=function(t,e){this.pdfStream.addText(t+" "+e+" m ")},x.prototype.setLineWidth=function(t){this.lineWidth=t},x.prototype.lineTo=function(t,e){this.pdfStream.addText(t+" "+e+" l ")},x.prototype.bezierCurveTo=function(t,e,i,o,n,r){this.pdfStream.addText(t+" "+e+" "+i+" "+o+" "+n+" "+r+" c ")},x.prototype.transform=function(t,e,i,o,n,r){var s,a,h,c,p,d,f,l,u;a=(s=this._ctm)[0],h=s[1],c=s[2],p=s[3],d=s[4],f=s[5],s[0]=a*t+c*e,s[1]=h*t+p*e,s[2]=a*i+c*o,s[3]=h*i+p*o,s[4]=a*n+c*r+d,s[5]=h*n+p*r+f,u=function(){var s,a,h,c;for(c=[],s=0,a=(h=[t,e,i,o,n,r]).length;s<a;s++)l=h[s],c.push(+l.toFixed(5));return c}().join(" "),this.pdfStream.addText(u+" cm ")},x.prototype.translate=function(t,e){this.transform(1,0,0,1,t,e)},x.prototype.rotate=function(t,e){var i,o,n,r,s,a,h;null==e&&(e={}),o=t*Math.PI/180,i=Math.cos(o),n=Math.sin(o),r=s=0,null!=e.origin&&(a=(r=(h=e.origin)[0])*n+(s=h[1])*i,r-=r*i-s*n,s-=a),this.transform(i,n,-n,i,r,s)},x.prototype.scale=function(t,e,i){var o,n,r;null==e&&(e=t),null==i&&(i={}),o=n=0,null!=i.origin&&(o=(r=i.origin)[0],n=r[1],o-=t*o,n-=e*n),this.transform(t,0,0,e,o,n)},x.prototype.stroke=function(){this.pdfStream.addTextCheckMerge("S ")},x.prototype.clip=function(t){this.pdfStream.addText((/even-?odd/.test(t)?"W* ":"W ")+" n ")},x.prototype.setLineDash=function(t){this.lineDash=t},x.prototype.saveContext=function(){this.pdfStream.addText("q ")},x.prototype.restoreContext=function(){this.pdfStream.addText("Q ")},x.prototype.fill=function(t){this.currentImageTile&&(this.setAlpha(1),this.pdfStream.addText("/Pattern cs "),this.pdfStream.addText("/Pattern CS "),this.pdfStream.addText("/Paint"+this.currentImageTile.id+" scn "),this.pdfStream.addText("/Paint"+this.currentImageTile.id+" SCN "),this.currentImageTile=void 0),this.pdfStream.addTextCheckMerge(/even-?odd/.test(t)?"f* ":"f ")},x.prototype.beginPath=function(){if(this.lineDash&&this.lineDash.length){this.pdfStream.addText("[");for(var t=0;t<this.lineDash.length;t++)this.pdfStream.addText(this.lineDash[t]),this.pdfStream.addText(" ");this.pdfStream.addText("] 0 d ")}this.setAlpha(this.alpha),this.pdfStream.addText(this.fillColor+" rg "),this.pdfStream.addText(this.strokeColor+" RG "),this.pdfStream.addText(this.lineCap+" J "+this.lineJoin+" j "+(1|this.lineWidth)+" w ")},x.prototype.setStrokeColor=function(t,e){this.strokeColor=t||"0 0 0",this.alpha=e},x.prototype.setFillColor=function(t,e){this.fillColor=t||"0 0 0",this.alpha=e},x.prototype.closePath=function(){this.pdfStream.addText("h ")},x.prototype.quadraticCurveTo=function(t,e,i,o){return this.pdfStream.addText(t+" "+e+" "+i+" "+o+" v ")},x.prototype._bezierCurve=function(t,e,i,o,n,r){var s=Math.PI,a=i,h=o,c=Math.cos(n*s/180),p=Math.sin(n*s/180),d=Math.cos((n+r)*s/180),f=Math.sin((n+r)*s/180),l=t+a*c,u=e-h*p,g=-a*p,m=-h*c,y=t+a*d,x=e-h*f,P=-a*f,v=-h*d,C=Math.tan(r/2*s/180),T=Math.sin(r*s/180)*(Math.sqrt(4+3*C*C)-1)/3;return[l,u,l+T*g,u+T*m,y-T*P,x-T*v,y,x]},x.prototype.arc=function(t,e,i,o,n,r){r&&console.log("Counterclockwise not supported"),o*=180/Math.PI,n*=180/Math.PI;for(var s=i-1,a=i-1,h=Math.ceil(Math.abs(n/45)),c=o,p=n/h,d=0;d<h;d++){var f=this._bezierCurve(t,e,s,a,c,p);0==d&&this.moveTo(f[0],f[1]),this.bezierCurveTo(f[2],f[3],f[4],f[5],f[6],f[7]),c+=p}},x.prototype.rect=function(t,e,i,o){var n=t+i,r=e+o;this.pdfStream.addText(t+" "+e+" m "+n+" "+e+" l "+n+" "+r+" l "+t+" "+r+" l "+t+" "+e+" l ")},x.prototype._CAP_STYLES={BUTT:0,ROUND:1,SQUARE:2},x.prototype.setLineCap=function(t){"string"==typeof t&&(t=this._CAP_STYLES[t.toUpperCase()]),this.lineCap=t},x.prototype._JOIN_STYLES={MITER:0,ROUND:1,BEVEL:2},x.prototype.setLineJoin=function(t){"string"==typeof t&&(t=this._JOIN_STYLES[t.toUpperCase()]),this.lineJoin=t},x.prototype.setFontSize=function(t){this.fontSize=t},x.prototype.transform=function(t,e,i,o,n,r){var s,a,h,c,p,d,f,l,u;a=(s=this._ctm)[0],h=s[1],c=s[2],p=s[3],d=s[4],f=s[5],s[0]=a*t+c*e,s[1]=h*t+p*e,s[2]=a*i+c*o,s[3]=h*i+p*o,s[4]=a*n+c*r+d,s[5]=h*n+p*r+f,u=function(){var s,a,h,c;for(c=[],s=0,a=(h=[t,e,i,o,n,r]).length;s<a;s++)l=h[s],c.push(+l.toFixed(5));return c}().join(" "),this.pdfStream.addText(u+" cm ")},x.prototype.drawImage=function(t,e,i,o,n,r){var s=i.scale||1;this.saveContext(),this.transform(1,0,0,-1,0,0),this.translate(t,-r/s-e),this.scale(n/s,r/s),this.pdfStream.addText("/Image"+i.id+" Do "),this.restoreContext(),-1==this.images.indexOf(i)&&this.images.push(i)},x.prototype.addPatternToPage=function(t){-1==this.fillImages.indexOf(t)&&this.fillImages.push(t)},x.prototype.getObject=function(t){t.pageSetCurrent(this);var e={Type:"Page"};e.Parent=new T(this.pagesID+" 0 R"),e.MediaBox=[0,0,this.width,this.height],e.Contents=new T(this.pdfStream.id+" 0 R");var i="<<";if(this.fonts.length>0)for(var o=0;o<this.fonts.length;o++){var n=this.fonts[o];i+="/F"+n.id+" "+n.id+" 0 R"}i+=">>";var r={};if(this.alphas.length>0)for(o=0;o<this.alphas.length;o++){var s=this.alphas[o];(isNaN(s)||void 0===s)&&(s="1"),"string"==typeof s&&(s*=1),r["Alpha"+o]={CA:s,ca:s}}var a="<<";if(this.images.length>0)for(var h=0;h<this.images.length;h++)a+="/Image"+(n=this.images[h]).id+" "+n.id+" 0 R";a+=">>";var c="<<";if(this.fillImages.length>0)for(h=0;h<this.fillImages.length;h++)c+="/Paint"+(n=this.fillImages[h]).id+" "+n.id+" 0 R";return c+=">>",e.Resources={},this.fonts.length>0&&(e.Resources.Font=new T(i)),this.alphas.length>0&&(e.Resources.ExtGState=r),this.fillImages.length>0&&(e.Resources.Pattern=new T(c)),this.images.length>0&&(e.Resources.XObject=new T(a)),C.makeObject(e,this.id)},P.TIMES=["Times-Roman","Times-Italic","Times-Bold","Times-BoldItalic"],P.HELVETICA=["Helvetica","Helvetica-Oblique","Helvetica-Bold","Helvetica-BoldOblique"],P.getPDFName=function(t,e,i){var o=(e?2:0)+(i?1:0);return"Helvetica"==t?P.HELVETICA[o]:P.TIMES[o]},P.prototype.getObject=function(){var t={Subtype:"Type1",Name:"F"+this.id,BaseFont:this.fontName,Encoding:"WinAnsiEncoding",Type:"Font"};return C.makeObject(t,this.id)},v.prototype.addText=function(t){this.stream+=t},v.prototype.addTextCheckMerge=function(t){function e(t,e){return-1!==t.indexOf(e,t.length-e.length)}"f* "==t&&e(this.stream," S ")?this.stream=this.stream.substring(0,this.stream.length-3)+" B* ":"S "==t&&e(this.stream," f* ")?this.stream=this.stream.substring(0,this.stream.length-4)+" B* ":"f "==t&&e(this.stream," S ")||"S "==t&&e(this.stream," f ")?this.stream=this.stream.substring(0,this.stream.length-3)+" B ":this.stream+=t},v.prototype.replaceText=function(t,e){this.stream=this.stream.replace(t,e)},v.prototype.getObject=function(){var t=S(this.stream),i={Length:t.length};return e.useFlateDecode&&(i.Filter="FlateDecode"),C.makeObject(i,this.id,t)};var C,T,S=function(t){if(e.useFlateDecode)t=e.deflate(t);else if("string"==typeof t)return t;for(var i=[],o=0;o<t.length;o++)i.push(String.fromCharCode(t[o]));return i.join("")};function w(t,e){this.width=t.width,this.height=t.height,this.isMask=!!e,e?this.stream=S(e):this.loadData(t)}function b(t,e,i,o,n){this.page=n,this.x1=t,this.y1=e,this.x2=i,this.y2=o,this.cols=["white","black"]}function I(t,e){this.stream=t,this.boundingBox=e}function j(t,i,o){if(t.getContext){this.width=t.width,this.height=t.height,this.boundingBox=[0,0,this.width,this.height];for(var n=[this.width+" 0.0000 0.0000 -"+this.height+" 0.0000 "+this.height+" cm ","BI ","/Width "+this.width+" ","/Height "+this.height+" ","/ColorSpace /DeviceRGB ","/BitsPerComponent 8 "],r=t.getContext("2d").getImageData(0,0,this.width,this.height),s=i.split(" ").map((t=>t*(1-o)+o)),a=new Uint8Array(this.width*this.height*3),h=0,c=this.height-1;c>=0;c--)for(var p=0;p<this.width;p++){var d=r.data[4*(p+c*this.width)],f=r.data[4*(p+c*this.width)+1],l=r.data[4*(p+c*this.width)+2],u=r.data[4*(p+c*this.width)+3];[d,f,l]=[d,f,l].map(((t,e)=>Math.round(parseFloat(t)/255*u+s[e]*(255-u)))),a[h++]=d,a[h++]=f,a[h++]=l}e.useFlateDecode&&n.push("/Filter /FlateDecode "),this.stream=n.join("")+"ID\n"+S(a)+"\nEI\n"}else{var g=t.doc.currentPage;this.boundingBox=t.boundingBox||[0,0,72*g.pdf.pageWidth,72*g.pdf.pageHeight],this.alphas=g.alphas,this.vectorPattern=new I(g.pdfStream.stream,this.boundingBox)}}function F(){this.fontName="Helvetica",this.fontSize=12,this.italic=!1,this.bold=!1,this.font=void 0,this.alpha=1}w.prototype.loadData=function(t){for(var e=t.getContext("2d"),i=new Uint8Array(this.height*this.width*3),o=e.getImageData(0,0,this.width,this.height),n=0,r=new Uint8Array(this.height*this.width),s=0,a=!1,h=0;h<this.height;h++)for(var c=0;c<this.width;c++){var p=o.data[4*(c+h*this.width)],d=o.data[4*(c+h*this.width)+1],f=o.data[4*(c+h*this.width)+2],l=o.data[4*(c+h*this.width)+3];i[n++]=p,i[n++]=d,i[n++]=f,r[s++]=l,255!=l&&(a=!0)}a&&(this.mask=new w(t,r)),this.stream=S(i)},w.prototype.writeImage=function(t){this.stream=t},w.prototype.getObject=function(){var t={Type:"XObject",Width:this.width,Height:this.height,Subtype:"Image",ColorSpace:this.isMask?"DeviceGray":"DeviceRGB",BitsPerComponent:8,Name:"Image"+this.id,Length:this.stream.length};return this.mask&&(t.SMask=new T(this.mask.id+" 0 R")),e.useFlateDecode&&(t.Filter="FlateDecode"),C.makeObject(t,this.id,this.stream)},b.prototype.addColorStop=function(t,e){0!=t&&1!=t&&console.error("only 0 and 1 supported for addColorStop",t),this.cols[Math.round(t)]=e},b.prototype.getObject=function(){var t=u(this.cols[0]).c.split(" "),e=u(this.cols[1]).c.split(" "),i={Type:"Pattern",PatternType:2,Shading:{ShadingType:2,Extend:[!0,!0],Coords:[this.x1,this.page.height-this.y1,this.x2,this.page.height-this.y2],ColorSpace:"DeviceRGB",Function:{FunctionType:2,N:1,Domain:[0,1],C0:[1*t[0],1*t[1],1*t[2]],C1:[1*e[0],1*e[1],1*e[2]]}}};return C.makeObject(i,this.id,this.stream)},I.prototype.getObject=function(){var t={Type:"XObject",Subtype:"Form",BBox:this.boundingBox};return C.makeObject(t,this.id,this.stream)},j.prototype.writeImage=function(t){this.stream=t},j.prototype.getObject=function(){var t={},e=[this.matrix?this.matrix.m11:1,0,0,this.matrix?this.matrix.m22:1,0,0];this.vectorPattern&&(this.stream=`/x${this.vectorPattern.id} Do`,t[`x${this.vectorPattern.id}`]=new T(this.vectorPattern.id+" 0 R"),e=[1,0,0,-1,0,0]);var i={Type:"Pattern",PatternType:1,PaintType:1,TilingType:1,BBox:this.boundingBox,XStep:this.boundingBox[2]-this.boundingBox[0],YStep:this.boundingBox[3]-this.boundingBox[1],Length:this.stream.length,Matrix:e,Resources:this.vectorPattern?{XObject:t}:{ProcSet:["PDF","ImageC"]}};return C.makeObject(i,this.id,this.stream)},F.prototype.setFontName=function(t){this.fontName=t,this.font=void 0},F.prototype.fontSetSize=function(t){this.fontSize=t},F.prototype.setFontStyle=function(t,e){this.bold=t,this.italic=e},F.prototype.setColor=function(t){this.color=t},F.prototype.setAlpha=function(t){this.alpha=t},F.prototype.getFontName=function(){return P.getPDFName(this.fontName,this.bold,this.italic)},F.prototype.setFont=function(t){this.font=t},F.prototype.clone=function(){var t=new F;return t.fontName=this.fontName,t.fontSize=this.fontSize,t.bold=this.bold,t.italic=this.italic,t.color=this.color,t.alpha=this.alpha,t.font=this.font,t},C=function(){var t,e,i;function o(){}return i=function(t,e){return(Array(e+1).join("0")+t).slice(-e)},e=/[\n\r\t\b\f()\\]/g,t={"\n":"\\n","\r":"\\r","\t":"\\t","\b":"\\b","\f":"\\f","\\":"\\\\","(":"\\(",")":"\\)"},o.makeObject=function(t,e,i){var n=e+" 0 obj\n"+o.convert(t);return i&&(n+="\nstream\n"+i+"\nendstream\n"),n+="endobj\n"},o.convert=function(n){var r,s,a,h,c,p,d,f,l;if("string"==typeof n)return"/"+n;if(n instanceof String){for(a=!1,s=f=0,l=(p=n.replace(e,(function(e){return t[e]}))).length;f<l;s=f+=1)if(p.charCodeAt(s)>127){a=!0;break}if(a){var u="";for(s=f=0,l=p.length;f<l;s=f+=1)p.charCodeAt(s)<=127?u+=p[s]:u+="?";p=u}return"("+p+")"}if(n instanceof T)return n.toString();if(n instanceof Date)return"(D:"+i(n.getUTCFullYear(),4)+i(n.getUTCMonth()+1,2)+i(n.getUTCDate(),2)+i(n.getUTCHours(),2)+i(n.getUTCMinutes(),2)+i(n.getUTCSeconds(),2)+"Z)";if(Array.isArray(n))return"["+function(){var t,e,i;for(i=[],t=0,e=n.length;t<e;t++)r=n[t],i.push(o.convert(r));return i}().join(" ")+"]";if("[object Object]"==={}.toString.call(n)){for(h in c=["<<"],n)d=n[h],c.push("/"+h+" "+o.convert(d));return c.push(">>"),c.join("")+"\n"}return""+n},o}(),T=function(){function t(t){this.str=t}return t.prototype.toString=function(){return this.str},t}()}("undefined"!=typeof window?window:this);